function [ct_separate,ct_together,ct_flag_separate,frequency_separate,frequency_together] = ct_modelsize_realdata(min_table2,num_seed)

    global k;
    global d;
    
    [row,col] = size(min_table2);
    if row ~= k*d && col ~= num_seed
        error('the size of min_table2 is not right');
    end
        
%     count zeros for k*d dimensions     
%     count non-zero frequency of (each dimension variable)*k among 100 seeds

    beta_ctseparate = min_table2; 
    ct_separate = zeros(k*d,1);
    ct_flag_separate = zeros(k*d, num_seed);
    for i = 1:k*d
        for j = 1:num_seed
            if beta_ctseparate(i,j)<1E-6 && beta_ctseparate(i,j)>-1E-6
                ct_separate(i,1) = ct_separate(i,1)+1; % if it's a zero, count add 1
                ct_flag_separate(i,j) = 1; % if it's a zero, mark is as 1
            end
        end
    end
    ct_separate = ones(k*d,1)*num_seed - ct_separate; % count # of non-zero
    
%     count zeros for d dimensions
%     count non-zero frequency of each dimension variable among 100 seeds

    beta_cttogether = reshape(beta_ctseparate, d, num_seed*k);
    ct_together = zeros(d,1);
    ct_flag_together = zeros(d,num_seed);
    if k == 4
        for i = 1:d
            for j = 1:num_seed
                if beta_cttogether(i,(j-1)*k+1)<1E-6 && beta_cttogether(i,(j-1)*k+1)>-1E-6
                    if beta_cttogether(i,(j-1)*k+2)<1E-6 && beta_cttogether(i,(j-1)*k+2)>-1E-6
                        if beta_cttogether(i,(j-1)*k+3)<1E-6 && beta_cttogether(i,(j-1)*k+3)>-1E-6
                           if beta_cttogether(i,(j-1)*k+4)<1E-6 && beta_cttogether(i,(j-1)*k+4)>-1E-6
                                ct_together(i,1) = ct_together(i,1)+1; % if all of them are equal to zero, count add 1
                                ct_flag_together(i,j) = 1;
                           end
                        end
                    end
                end
            end
        end
    elseif k == 5
        for i = 1:d
            for j = 1:num_seed
                if beta_cttogether(i,(j-1)*k+1)<1E-6 && beta_cttogether(i,(j-1)*k+1)>-1E-6
                    if beta_cttogether(i,(j-1)*k+2)<1E-6 && beta_cttogether(i,(j-1)*k+2)>-1E-6
                        if beta_cttogether(i,(j-1)*k+3)<1E-6 && beta_cttogether(i,(j-1)*k+3)>-1E-6
                           if beta_cttogether(i,(j-1)*k+4)<1E-6 && beta_cttogether(i,(j-1)*k+4)>-1E-6
                              if beta_cttogether(i,(j-1)*k+5)<1E-6 && beta_cttogether(i,(j-1)*k+5)>-1E-6
                                ct_together(i,1) = ct_together(i,1)+1; % if all of them are equal to zero, count add 1
                                ct_flag_together(i,j) = 1;
                              end
                           end
                        end
                    end
                end
            end
        end   
    elseif k == 2
        for i = 1:d
            for j = 1:num_seed
                if beta_cttogether(i,(j-1)*k+1)<1E-6 && beta_cttogether(i,(j-1)*k+1)>-1E-6
                    if beta_cttogether(i,(j-1)*k+2)<1E-6 && beta_cttogether(i,(j-1)*k+2)>-1E-6              
                                ct_together(i,1) = ct_together(i,1)+1;
                                ct_flag_together(i,j) = 1;
                    end
                end
            end
        end
    elseif k == 3
        for i = 1:d
            for j = 1:num_seed
                if beta_cttogether(i,(j-1)*k+1)<1E-6 && beta_cttogether(i,(j-1)*k+1)>-1E-6
                    if beta_cttogether(i,(j-1)*k+2)<1E-6 && beta_cttogether(i,(j-1)*k+2)>-1E-6      
                        if beta_cttogether(i,(j-1)*k+3)<1E-6 && beta_cttogether(i,(j-1)*k+3)>-1E-6
                                ct_together(i,1) = ct_together(i,1)+1;
                                ct_flag_together(i,j) = 1;
                        end
                    end
                end
            end
        end
    else
        error('I only coded the k equal to 2 or 4');
    end
    ct_together = ones(d,1)*num_seed - ct_together;

    %%%%%%%%%%%%%%%%%%%%%%%%%
    % count correct zeros for k*dnoise dimensions 
    % corr_zero_matrix_separate[dnoise*k,num_seed] - a flag matrix for noise varialbles
    % corr_zero_vec_separate[1,num_seed] - a corr_zero model size for eaach seed
    %%%%%%%%%%%%%%%%%%%%%%%%%
    
    pre_frequency_separate = sum(ct_flag_separate); 
    frequency_separate = ones(1,num_seed)*k*d-pre_frequency_separate; 
    
    %%%%%%%%%%%%%%%%%%%%%%%%%
    % count incorrect zeros for k*(d-dnoise) dimensions 
    % corr_zero_matrix_separate[(d-dnoise)*k,num_seed] - a flag matrix for important varialbles
    % corr_zero_vec_separate[1,num_seed] - a incorr_zero model size for eaach seed
    %%%%%%%%%%%%%%%%%%%%%%%%%

   
    %%%%%%%%%%%%%%%%%%%%%%%%%
    % count correct zeros for dnoise dimensions
    % corr_zero_matrix_together[dnoise,num_seed] - a flag matrix for noise varialbles
    % corr_zero_vec_together[1,num_seed] - a corr_zero model size for eaach seed
    %%%%%%%%%%%%%%%%%%%%%%%%%

    pre_frequency_together = sum(ct_flag_together);
    frequency_together = ones(1,num_seed)*d-pre_frequency_together; 

    %%%%%%%%%%%%%%%%%%%%%%%%%
    % count incorrect zeros for k*(d-dnoise) dimensions
    % incorr_zero_matrix_together[d-dnoise,num_seed] - a flag matrix for important varialbles
    % incorr_zero_vec_together[1,num_seed] - a incorr_zero model size for eaach seed
    %%%%%%%%%%%%%%%%%%%%%%%%%


